/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.ventas;

import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Comprador
extends Sujeto
implements Importable,
Exportable {
    private static final long serialVersionUID = -7165096025356786368L;
    public static final String C_PARTE_RELACIONADA = "parteRelacionada";
    private boolean parteRelacionada;

    public Comprador() {
        this.parteRelacionada = false;
    }

    public Comprador(String tipoIdentificacion, String identificacion) {
        super(tipoIdentificacion, identificacion, "2");
    }

    @Override
    public Comprador crearCopiaEdicion() {
        Comprador copia = new Comprador();
        copia.setTipoIdentificacion(super.getTipoIdentificacion());
        copia.setIdentificacion(super.getIdentificacion());
        copia.setDescripcionTipoIdentificacion(super.getDescripcionTipoIdentificacion());
        copia.setParteRelacionada(this.parteRelacionada);
        copia.setTipoProveedor(this.getTipoProveedor());
        copia.setDescripcionTipoProveedor(this.getDescripcionTipoProveedor());
        copia.setRazonSocial(this.getRazonSocial());
        copia.setPropietario(this.propietario);
        return copia;
    }

    @Override
    public void actualizarInformacion(Sujeto copiaEdicion) {
        Comprador comprador = (Comprador)copiaEdicion;
        super.actualizarInformacion(copiaEdicion);
        this.setParteRelacionada(comprador.parteRelacionada);
    }

    public Comprador importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("tpIdCliente");
        Element eValor = (Element)valorList.item(0);
        this.setTipoIdentificacion(UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacionSecuencia("2", eValor.getTextContent().trim()));
        this.setDescripcionTipoIdentificacion(Constantes.CATALOGOS_SUJETO.get(this.getTipoIdentificacion()));
        valorList = elemento.getElementsByTagName("idCliente");
        eValor = (Element)valorList.item(0);
        this.setIdentificacion(eValor.getTextContent().trim());
        if (!"F".equals(this.getTipoIdentificacion()) && !"L".equals(this.getTipoIdentificacion()) && Util.existeElementoImportar(elemento, "parteRelVtas")) {
            valorList = elemento.getElementsByTagName("parteRelVtas");
            eValor = (Element)valorList.item(0);
            this.setParteRelacionada(Util.importarBooleano(eValor));
        }
        if (Util.existeElementoImportar(elemento, "tipoCliente")) {
            valorList = elemento.getElementsByTagName("tipoCliente");
            eValor = (Element)valorList.item(0);
            this.setTipoProveedor(eValor.getTextContent().trim());
            this.setDescripcionTipoProveedor(UtilCatalogosATS.obtenerNombreDetalleCatalogo((String)"TIPOSIDPROV", (String)this.getTipoProveedor()));
        }
        if (Util.existeElementoImportar(elemento, "denoCli")) {
            valorList = elemento.getElementsByTagName("denoCli");
            eValor = (Element)valorList.item(0);
            this.setRazonSocial(eValor.getTextContent().trim());
        }
        return this;
    }

    public Element exportar(Document documento, Element detalleVentas) {
        Element emDv = documento.createElement("tpIdCliente");
        String codTpoIdentf = UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacion("2", this.getTipoIdentificacion());
        emDv.setTextContent(codTpoIdentf);
        detalleVentas.appendChild(emDv);
        emDv = documento.createElement("idCliente");
        emDv.setTextContent(this.getIdentificacion());
        detalleVentas.appendChild(emDv);
        if (!"F".equals(this.getTipoIdentificacion()) && !"L".equals(this.getTipoIdentificacion()) && ((Iva)this.getRaizModelo()).periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            emDv = documento.createElement("parteRelVtas");
            emDv.setTextContent(this.getParteRelacionada());
            detalleVentas.appendChild(emDv);
        }
        emDv = documento.createElement("tipoCliente");
        emDv.setTextContent(this.getTipoProveedor());
        detalleVentas.appendChild(emDv);
        emDv = documento.createElement("denoCli");
        emDv.setTextContent(this.getRazonSocial());
        detalleVentas.appendChild(emDv);
        return emDv;
    }

    @Override
    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        Iva iva = (Iva)this.getRaizModelo();
        if (iva.periodo.isAnexoEnPeriodoDesdeMayo2016() && "P".equals(this.getTipoIdentificacion())) {
            if (this.getTipoProveedor() == null) {
                resultado.fallarValidacion("Debe seleccionar el tipo de cliente");
                return resultado;
            }
            resultado = this.validarRazonSocial(iva.periodo, "cliente", resultado);
        }
        return resultado;
    }

    public boolean isParteRelacionada() {
        return this.parteRelacionada;
    }

    public String getParteRelacionada() {
        return this.parteRelacionada ? "SI" : "NO";
    }

    public void setParteRelacionada(boolean parteRelacionada) {
        boolean oldValue = this.parteRelacionada;
        this.parteRelacionada = parteRelacionada;
        this.firePropertyChange(C_PARTE_RELACIONADA, oldValue, this.parteRelacionada);
    }
}

